#!/usr/bin/python
# -*- coding: utf-8 -*-

import os, codecs, re, sys
from textblob_de import TextBlobDE
from lxml import etree

paragraphs = codecs.open('Marlitt_Eulenhaus_Pentecost_Gartenlaube.txt', 'r', encoding='utf-8').read().split('\r')

p_n = 0
s_n = 0

root = etree.Element('text')

for p in paragraphs:

    if p.strip() > '':

        #paragraph_type = 'UNKNOWN'

        #if p.find(u'„') > -1 and p.find(u'“') > -1:
        #    paragraph_type = 'dialog'

        p_node = etree.Element('p')
        p_node.set('n', str(p_n))
        root.append(p_node)

        p_n += 1

        blob = TextBlobDE(p)

        for s in blob.sentences:

            s_node = etree.Element('sentence')
            s_node.set('n', str(s_n))
            s_node.text = s.raw
            p_node.append(s_node)

            s_n += 1
            

print etree.tostring(root, pretty_print=True)
