#!/usr/bin/python
# -*- coding: utf-8 -*-

import os, codecs, re, sys
from textblob_de import TextBlobDE

INPUT_FILE = sys.argv[1]
LIST_ALL_PARAGRAPHS = bool(sys.argv[2])

all_examples = [u'Aber das war wohl nur Einbildung gewesen, hervorgerufen durch das Schattenspiel.',  u'Was hatte sie ihr genutzt, ihre Flucht? Glaubte nicht gerade Er – Er das Schlimmste von ihr? Sein Lächeln – die Reden heute Abend – hätten es ihr gezeigt, auch wenn sie es nicht schon längst gewußt. O, die ganze Welt mochte denken von ihr, was sie wollte – wenn nur ihr Herz, ihr Gewissen rein blieb! Sie allein würde dafür sorgen, daß sie den Blick nicht niederzuschlagen brauchte.',  u'Was ging ihn das an, wenn ihr wehgeschah? Er würde es sicher kaum bemerkt haben, wenn sie nicht den Namen „Gerold“ trug.',  u'Was wollte sie denn eigentlich? – Es war doch nicht anders, als es eben war!',  u'Es waren glückliche Zeiten – wo waren sie geblieben?',  u'Wie, wenn man von ihr bereits wisperte und spräche? Und wenn es geglaubt würde? Wenn es einer bereits glaubte, daß sie ihre Ehre schon vergessen habe?',  u'War sie zu schroff gewesen?',  u'War es körperlich? War es das Herz?',  u'O, sie wußte am besten, wie sehr man diesen Mann lieben mußte!',  u'sollte sie übersehen haben, daß er ohne dies ein recht, recht schmuckloser gewesen? Daß sie allein davor gebetet?',  u'Wie kam sie nur darauf? Nein, sie hatte sich nicht hineinphantasiert in dieses Glück, sie besaß es wirklich! Er war doch stets so freundlich, so nachsichtig, so ritterlich gewesen, besonders jetzt, wo sie krank war.',  u'Aber niemals hatte er ihr doch einen Grund zur Eifersucht gegeben, dieser bürgerlichen Leidenschaft, wie Prinzeß Thekla sagte, die eine Fürstin nie besitzen dürfe.',  u'War sie denn blind gewesen? Was konnte sie ihm noch sein, sie, die Kranke, dem Grabe Zuwankende? Nichts, nichts als eine Last. Nur das nicht, das nicht!',  u'Aber konnten sie nicht warten, bis sie todt war? Wie lange würde es denn noch dauern?',  u'Sie war wohl müde von der gestrigen Nacht',  u'Was war es mit der Herzogin? Dieses Anstarren, diese Kälte, diese leidenschaftliche Zärtlichkeit?',  u'Weshalb rief man sie denn nicht zu Ihrer Hoheit?',  u'Niemand durfte es ahnen, wie arm sie geworden!',  u'Nur diese kurze Rast noch, nur diese eine Stunde, um das todeswunde Herz zu beschwichtigen, zu betäuben! – Gönnte man ihr auch das nicht?',  u'Fragte denn Ihre Hoheit nicht nach ihr?',  u'Wie gut sie sich in der Gewalt hatten! Se. Hoheit streifte dieses schöne Mädchen kaum mit einem Blick.',  u'Sie mußten sich brillant eingeübt haben im Verstellen! Ach nein, sie hatten so leichtes Spiel ihr, der vertrauenden gläubigen Törin, gegenüber!',  u'Ach, und da draußen die Welt! Ob man es dort wußte? Ob man lächelte und flüsterte über die verratene Frau, welche die Geliebte ihres Mannes für eine Freundin hielt?',  u'Warum befahl die Herzogin-Mutter sie nicht? Warum kam nicht wenigstens Fräulein von Böhlen, ihre Nachfolgerin bei der alten Hoheit, sie zu begrüßen? Es war doch Usance, daß die Damen sich besuchten Und bei Frau von Katzenstein hatte die blasse, gelangweilt aussehende junge Dame mit dem rötlich blonden Haar und den unzähligen Sommersprossen schon vor einer halben Stunde angeklopft.',  u'Was kümmerte sie der Schmerz und die Qual anderer? ',  u'Es war sehr unangenehm, sehr! ',  u'Es war doch ein Trost, diese Berg zur Seite zu haben; wie brillant hatte sie dieses „Unmöglichmachen“ in Scene gesetzt am Geburtstage des Prinzen! Die alte Herzogin hatte Claudine fallen lassen, das war so unbezahlbar! Der Mutter gegenüber würde selbst Seine Hoheit nicht den Mut finden, dieses Schäferspiel weiter zu agieren. Wundervoll! Ganz wundervoll!',  u'Dahin war es gekommen, dahin?! Die Welt hielt sie für eine Gesunkene, für die Geliebte des Herzogs – sein eigenes Weib starb in diesem Wahne!',  u'O, diese törichte Vermessenheit ihres wahnsinnigen Stolzes! Und wenn sie die Sterne vom Himmel herunter holen könnte als Zeugen ihrer Reinheit – niemand würde ihr glauben, niemand, die Sterbende nicht und die Lebenden nicht, und jener eine nicht, den sie zurückstieß, als er sie warnte! Gott allein wußte es, daß sie rein, aber Gott tut keine Wunder mehr. Verloren! Verloren! – Der Schandfleck ihrer Familie war sie geworden, das ganze Land würde mit Fingern auf sie weisen.',  u'Wer sollte sie retten? Der Herzog? – Er konnte nicht für sie in die Schranken treten; sie hätten alle getan, als ob sie ihm glaubten, und hätten gelacht hinterher. – Barmherziger Gott, was that sie den Menschen, daß man sie haßte, so bitter haßte?']

paragraphs = codecs.open(INPUT_FILE, 'r', encoding='utf-8').read().split('\r')

for p in paragraphs:

    if p.strip() > '':

        blob = TextBlobDE(p)

        is_indirect = False

        for s in blob.sentences:

            if s.raw.endswith('?') and s.raw.find(u'“') == -1 and s.raw.find(u'„') == -1:
                if s.words[0].lower() == 'was':
                    is_indirect = True

        if is_indirect == True or LIST_ALL_PARAGRAPHS == False:

            in_examples = False
            for a in all_examples:
                if p.find(a) > -1 or a.find(p) > -1:
                    in_examples = True
            
            print
            print in_examples, p


