#!/usr/bin/python
# -*- coding: utf-8 -*-

import os, codecs, re, sys
from textblob_de import TextBlobDE
from lxml import etree

all_examples = [u'Aber das war wohl nur Einbildung gewesen, hervorgerufen durch das Schattenspiel.',  u'Was hatte sie ihr genutzt, ihre Flucht? Glaubte nicht gerade Er – Er das Schlimmste von ihr? Sein Lächeln – die Reden heute Abend – hätten es ihr gezeigt, auch wenn sie es nicht schon längst gewußt. O, die ganze Welt mochte denken von ihr, was sie wollte – wenn nur ihr Herz, ihr Gewissen rein blieb! Sie allein würde dafür sorgen, daß sie den Blick nicht niederzuschlagen brauchte.',  u'Was ging ihn das an, wenn ihr wehgeschah? Er würde es sicher kaum bemerkt haben, wenn sie nicht den Namen „Gerold“ trug.',  u'Was wollte sie denn eigentlich? – Es war doch nicht anders, als es eben war!',  u'Es waren glückliche Zeiten – wo waren sie geblieben?',  u'Wie, wenn man von ihr bereits wisperte und spräche? Und wenn es geglaubt würde? Wenn es einer bereits glaubte, daß sie ihre Ehre schon vergessen habe?',  u'War sie zu schroff gewesen?',  u'War es körperlich? War es das Herz?',  u'O, sie wußte am besten, wie sehr man diesen Mann lieben mußte!',  u'sollte sie übersehen haben, daß er ohne dies ein recht, recht schmuckloser gewesen? Daß sie allein davor gebetet?',  u'Wie kam sie nur darauf? Nein, sie hatte sich nicht hineinphantasiert in dieses Glück, sie besaß es wirklich! Er war doch stets so freundlich, so nachsichtig, so ritterlich gewesen, besonders jetzt, wo sie krank war.',  u'Aber niemals hatte er ihr doch einen Grund zur Eifersucht gegeben, dieser bürgerlichen Leidenschaft, wie Prinzeß Thekla sagte, die eine Fürstin nie besitzen dürfe.',  u'War sie denn blind gewesen? Was konnte sie ihm noch sein, sie, die Kranke, dem Grabe Zuwankende? Nichts, nichts als eine Last. Nur das nicht, das nicht!',  u'Aber konnten sie nicht warten, bis sie todt war? Wie lange würde es denn noch dauern?',  u'Sie war wohl müde von der gestrigen Nacht',  u'Was war es mit der Herzogin? Dieses Anstarren, diese Kälte, diese leidenschaftliche Zärtlichkeit?',  u'Weshalb rief man sie denn nicht zu Ihrer Hoheit?',  u'Niemand durfte es ahnen, wie arm sie geworden!',  u'Nur diese kurze Rast noch, nur diese eine Stunde, um das todeswunde Herz zu beschwichtigen, zu betäuben! – Gönnte man ihr auch das nicht?',  u'Fragte denn Ihre Hoheit nicht nach ihr?',  u'Wie gut sie sich in der Gewalt hatten! Se. Hoheit streifte dieses schöne Mädchen kaum mit einem Blick.',  u'Sie mußten sich brillant eingeübt haben im Verstellen! Ach nein, sie hatten so leichtes Spiel ihr, der vertrauenden gläubigen Törin, gegenüber!',  u'Ach, und da draußen die Welt! Ob man es dort wußte? Ob man lächelte und flüsterte über die verratene Frau, welche die Geliebte ihres Mannes für eine Freundin hielt?',  u'Warum befahl die Herzogin-Mutter sie nicht? Warum kam nicht wenigstens Fräulein von Böhlen, ihre Nachfolgerin bei der alten Hoheit, sie zu begrüßen? Es war doch Usance, daß die Damen sich besuchten Und bei Frau von Katzenstein hatte die blasse, gelangweilt aussehende junge Dame mit dem rötlich blonden Haar und den unzähligen Sommersprossen schon vor einer halben Stunde angeklopft.',  u'Was kümmerte sie der Schmerz und die Qual anderer? ',  u'Es war sehr unangenehm, sehr! ',  u'Es war doch ein Trost, diese Berg zur Seite zu haben; wie brillant hatte sie dieses „Unmöglichmachen“ in Scene gesetzt am Geburtstage des Prinzen! Die alte Herzogin hatte Claudine fallen lassen, das war so unbezahlbar! Der Mutter gegenüber würde selbst Seine Hoheit nicht den Mut finden, dieses Schäferspiel weiter zu agieren. Wundervoll! Ganz wundervoll!',  u'Dahin war es gekommen, dahin?! Die Welt hielt sie für eine Gesunkene, für die Geliebte des Herzogs – sein eigenes Weib starb in diesem Wahne!',  u'O, diese törichte Vermessenheit ihres wahnsinnigen Stolzes! Und wenn sie die Sterne vom Himmel herunter holen könnte als Zeugen ihrer Reinheit – niemand würde ihr glauben, niemand, die Sterbende nicht und die Lebenden nicht, und jener eine nicht, den sie zurückstieß, als er sie warnte! Gott allein wußte es, daß sie rein, aber Gott tut keine Wunder mehr. Verloren! Verloren! – Der Schandfleck ihrer Familie war sie geworden, das ganze Land würde mit Fingern auf sie weisen.',  u'Wer sollte sie retten? Der Herzog? – Er konnte nicht für sie in die Schranken treten; sie hätten alle getan, als ob sie ihm glaubten, und hätten gelacht hinterher. – Barmherziger Gott, was that sie den Menschen, daß man sie haßte, so bitter haßte?']

magic_words = {u'haßte': 95.926616191, u'brillant': 95.926616191, u'wundervoll': 57.5559697147, u'geliebte': 47.9633080955, u'rein': 35.9724810717, u'hätten': 35.9724810715, u'dahin': 31.9755387303, u'niemand': 28.7779848572, u'glaubte': 20.5557034695, u'verloren': 15.1463078196, u'gegenüber': 11.0684557144, u'welt': 10.5285310453, u'würde': 10.2778517347, u'dieses': 9.9923558532, u'stunde': 9.2832209217, u'warum': 7.7778337452, u'herz': 7.708388801, u'gewesen': 7.6537193769, u'ob': 7.3164368281, u'wußte': 7.3164368281, u'bereits': 7.1944962143, u'allein': 6.7448402009, u'ganze': 6.2560836646, u'?': 5.9798410093, u'ihres': 5.6427421289, u'geworden': 5.4298084636, u'kaum': 5.4298084636, u'sollte': 5.3292564551, u'diese': 5.1389258674, u'denn': 5.1389258674, u'was': 4.9832008411, u'ach': 4.9617215271, u'sehr': 4.9617215271, u'hielt': 4.6416104609, u'man': 4.4371342291, u'gott': 4.4047936006, u'wenn': 4.3768798262, u'recht': 4.2320565967, u'o': 4.2320565967, u'konnte': 4.1707224431, u'mutter': 4.0532373038}

text = re.sub('\s+', ' ', codecs.open(sys.argv[1], 'r', encoding='utf-8').read())

temp = re.split(u'(\„|\“)', text)

passages = []

for t in temp:
    if len(passages) > 0 and passages[-1] == u'„':
        passages[-1] = passages[-1] + t
    else:
        if t == u'“':
            passages[-1] = passages[-1] + t
        else:
            passages.append(t)

for i, p in enumerate(passages):

    if p.startswith(u'„'):
        #print str(i) + '\t' + 'reported_speech' + '\t\t' + p
        pass
    else:

        tokens = re.split(u'(\s|~|`|!|\@|\#|\$|\%|\^|\&|\*|\(|\)|\[|\{|\]|\}|\;|\:|\'|\"|\<|\,|\>|\.|\?|\/|\\|\_|\-|\+|\=|»|«|–|\„|\“|\’|\–|\›|\‹|\‚|\‘|\…|–)', p)

        passage_score = 0

        for t in tokens:
            try:
                passage_score = passage_score + magic_words[t.lower()]
            except KeyError:
                pass

        in_examples = False
        if passage_score > 0:
            for a in all_examples:
                if p.find(a) > -1 or a.find(p) > -1:
                    in_examples = True

        print str(i) + '\t' + str(in_examples) + '\t' + str(int(passage_score)) + '\t' + str(passage_score / float(len(tokens))) + '\t' + p
