<?xml version="1.0"?>
<xsl:stylesheet 
    version="2.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:tei="http://www.tei-c.org/ns/1.0">
    
    <xsl:output 
        method="xml" 
        encoding="utf-8" 
        omit-xml-declaration="yes"
        indent="yes"/>
    
    <xsl:template match="tei:choice">
        <xsl:if test="descendant::tei:reg[@type='characterNormalization']">
            <choice>
                <orig>
                    <xsl:apply-templates select="descendant::tei:orig"/>    
                </orig>
                <reg>
                    <xsl:apply-templates select="descendant::tei:reg[@type='characterNormalization']"/>    
                </reg>
            </choice>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="/">
       <xsl:apply-templates select="//tei:choice"/>
    </xsl:template>
    
</xsl:stylesheet>
